local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end


// window init.
function PANEL:Init( )
	//
	self.LinkedClass = nil;
	
	// material
	self.Material = nil;
	
	// text
	self.Text = nil;
	
end

// set material
function PANEL:SetMaterial( mat )
	// get texture id.
	self.Material = surface.GetTextureID( mat );
	
end


// clicked
function PANEL:DoClick( )
	// exec
	if( self.LinkedClass ) then
		self.LinkedClass:CallEvent( "OnClick" );
		
	end
	
end

// set text
function PANEL:SetText( txt )
	self.Text = txt;
	
end

// paint.
function PANEL:Paint( )
	// no icon!
	if( !self.Material ) then return; end
	
	// brightness
	local brightness = 128;
	if( self.Armed ) then brightness = 255; end
	
	// width/height
	local width, height = self:GetSize();
	
	// draw border.
	local color = AppFramework:Theme().colors['selection'];
	surface.SetDrawColor(
		color.r,
		color.g,
		color.b,
		color.a
	);
	surface.DrawRect(
		0, 0,
		width, height
	);
	
	// draw icon
	surface.SetDrawColor( brightness, brightness, brightness, 255 );
	surface.SetTexture( self.Material );
	surface.DrawTexturedRect(
		1, 1,
		width - 2, height - 2
	);
	
	// text?
	if( self.Text ) then
		local color = AppFramework:Theme().colors['selection'];
		
		// draw overlay bar.
		surface.SetDrawColor(
			color.r,
			color.g,
			color.b,
			40
		);
		surface.DrawRect(
			1, height - 17,
			width - 2, 16
		);
		
		// draw text
		draw.SimpleText(
			self.Text,
			AppFramework:Theme().fonts['text'],
			width * 0.5, height - 8,
			AppFramework:Theme().colors['text'],
			TEXT_ALIGN_CENTER,
			TEXT_ALIGN_CENTER
		);
	
	end
	
	//
	return true;
	
end

// register.
vgui.Register( "ctl_imagebutton", PANEL, "Button" );




// create app framework control.
CtlImageButton_class 	= Control_class:create( nil, false, "ctl_imagebutton" );

// set text
function CtlImageButton_class:SetText( txt )
	self:GetHandle():SetText( txt );

end

// set material
function CtlImageButton_class:SetMaterial( m )
	self:GetHandle():SetMaterial( m );	

end
